/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.route.strategy;

import com.xxl.job.admin.core.route.ExecutorRouter;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.biz.model.TriggerParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExecutorRouteLRU
extends ExecutorRouter {
    private static ConcurrentMap<Integer, LinkedHashMap<String, String>> jobLRUMap = new ConcurrentHashMap();
    private static long CACHE_VALID_TIME = 0L;

    public String route(int jobId, List<String> addressList) {
        LinkedHashMap<String, String> lruItem;
        if (System.currentTimeMillis() > CACHE_VALID_TIME) {
            jobLRUMap.clear();
            CACHE_VALID_TIME = System.currentTimeMillis() + 86400000L;
        }
        if ((lruItem = (LinkedHashMap<String, String>)jobLRUMap.get(jobId)) == null) {
            lruItem = new LinkedHashMap<String, String>(16, 0.75f, true);
            jobLRUMap.putIfAbsent(jobId, lruItem);
        }
        for (String string : addressList) {
            if (lruItem.containsKey(string)) continue;
            lruItem.put(string, string);
        }
        ArrayList<String> delKeys = new ArrayList<String>();
        for (String existKey : lruItem.keySet()) {
            if (addressList.contains(existKey)) continue;
            delKeys.add(existKey);
        }
        if (delKeys.size() > 0) {
            for (String delKey : delKeys) {
                lruItem.remove(delKey);
            }
        }
        String string = (String)lruItem.entrySet().iterator().next().getKey();
        String eldestValue = (String)lruItem.get(string);
        return eldestValue;
    }

    public ReturnT<String> route(TriggerParam triggerParam, List<String> addressList) {
        String address = this.route(triggerParam.getJobId(), addressList);
        return new ReturnT((Object)address);
    }
}

